<?php
if (!function_exists('poker_theme_asset')) {
    function poker_theme_asset($path)
    {
        return get_template_directory_uri() . "/assets/$path";
    }
}

//get link to page with template
function poker_get_template_page_link($template_file)
{
    $url = null;

    $pages = query_posts(array(
        'post_type' => 'page',
        'meta_key'  => '_wp_page_template',
        'meta_value' => $template_file,
    ));

    if (isset($pages[0])) {
        $url = get_permalink($pages[0]->ID);
    }
    return $url;
}

function poker_get_user_full_name($user_obj)
{
    $fname = get_the_author_meta('first_name', $user_obj->data->ID);
    $lname = get_the_author_meta('last_name', $user_obj->data->ID);
    $full_name = strlen("$fname $lname") < 2 ? $user_obj->data->nickname : "$fname $lname";

    return $full_name;
}

if (!function_exists('poker_insert_attachment_from_url')) {
    function poker_insert_attachment_from_url($url, $parent_post_id = null)
    {

        if (!class_exists('WP_Http'))
            include_once(ABSPATH . WPINC . '/class-http.php');

        $http = new WP_Http();
        $response = $http->request($url);
        if ($response['response']['code'] != 200) {
            return false;
        }

        $upload = wp_upload_bits(basename($url), null, $response['body']);
        if (!empty($upload['error'])) {
            return false;
        }

        $file_path = $upload['file'];
        $file_name = basename($file_path);
        $file_type = wp_check_filetype($file_name, null);
        $attachment_title = sanitize_file_name(pathinfo($file_name, PATHINFO_FILENAME));
        $wp_upload_dir = wp_upload_dir();

        $post_info = array(
            'guid'           => $wp_upload_dir['url'] . '/' . $file_name,
            'post_mime_type' => $file_type['type'],
            'post_title'     => $attachment_title,
            'post_content'   => '',
            'post_status'    => 'inherit',
        );

        // Create the attachment
        $attach_id = wp_insert_attachment($post_info, $file_path, $parent_post_id);

        // Include image.php
        require_once(ABSPATH . 'wp-admin/includes/image.php');

        // Define attachment metadata
        $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);

        // Assign metadata to attachment
        wp_update_attachment_metadata($attach_id,  $attach_data);

        return $attach_id;
    }
}
